// Author: Sally Hudson
// This program estimates ATE using discrete covariate matching.

program matching, rclass

	// initialize arguments and outputs
	args y d x
	confirm var `y' `d' `x'
	local delta = 0
	
	// loop over values of binning variable
	levelsof `x', local(xs)
	foreach k of local xs {
	
		// initialize skip flag for cells that don't have both treateds and controls
		local skip = 0
		forvalues t = 0/1 {
		
			// get treated and control means
			sum `y' if (`x' == `k') & (`d' == `t')
			local y`t' = r(mean)
			
			// flag skips 
			if r(N) == 0 {
				local skip = 1
			}
		}
		
		// weight within cell contrast by share of sample
		if !`skip' {
			count if (`x' == `k')
			local delta = `delta' + ((r(N)/_N) * (`y1'-`y0'))
		}
	}
	
	// return matching estimate
	return scalar ate = `delta'
	
end
